/*
 * Decompiled with CFR 0.152.
 */
package standard;

import com.nokia.mid.appl.calc2.Local;
import common.control.Calculator2;
import common.control.DisplayManager;
import common.control.SettingsManager;
import common.misc.GlobalParameters;
import common.ui.CalculatorCanvas;
import common.ui.DisplaySizes;
import common.ui.InstructionsForm;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;
import standard.AdditionalFunctionsButtonPanel;
import standard.StandaloneButton;
import standard.StandardEditPanel;

public final class StandardCanvas
extends CalculatorCanvas {
    public static final int ID = 0;
    private static final Command COMMAND_EQUALS = new Command("Equals", 4, 0);
    private static final Command COMMAND_SCIENTIFIC_CALCULATOR = new Command(Local.getText(15), 1, 1);
    static final int STATE_NON_ADDITIONAL_FUNCTIONS = 0;
    static final int STATE_ADDITIONAL_FUNCTIONS_MOVING_IN = 1;
    static final int STATE_ADDITIONAL_FUNCTIONS = 2;
    static final int STATE_ADDITIONAL_FUNCTIONS_MOVING_OUT = 3;
    private int currentState = -1;
    private final StandaloneButton starButton;
    private final StandaloneButton hashButton;
    private final StandaloneButton middleButton;
    private Alert alert;

    public StandardCanvas(Calculator2 midlet) {
        super(midlet);
        this.setTitle(Local.getText(28));
        this.editPanel = new StandardEditPanel(this.displaySize);
        this.buttonPanel = new AdditionalFunctionsButtonPanel(this.displaySize);
        this.editPanel.setCalculatorCanvas(this);
        this.buttonPanel.setCalculatorCanvas(this);
        this.buttonPanel.setEditPanel(this.editPanel);
        this.starButton = new StandaloneButton(this.displaySize, 29);
        this.hashButton = new StandaloneButton(this.displaySize, 30);
        this.middleButton = new StandaloneButton(this.displaySize, 31);
        this.starButton.setCalculatorCanvas(this);
        this.starButton.setEditPanel(this.editPanel);
        this.hashButton.setCalculatorCanvas(this);
        this.hashButton.setEditPanel(this.editPanel);
        this.middleButton.setCalculatorCanvas(this);
        this.middleButton.setEditPanel(this.editPanel);
        this.changeState(0);
    }

    public void paint(Graphics g) {
        if (this.currentState == 0) {
            if (this.displaySize == DisplaySizes.S60_3_1 || this.displaySize == DisplaySizes.S60_3_1_OLD || this.displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK || this.displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK) {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(0);
            }
            this.starButton.paint(g);
            this.hashButton.paint(g);
            this.middleButton.paint(g);
        } else {
            if (this.displaySize == DisplaySizes.S60_3_1 || this.displaySize == DisplaySizes.S60_3_1_OLD || this.displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK || this.displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK) {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(0);
            }
            this.buttonPanel.paint(g);
        }
        super.paint(g);
    }

    public void commandAction(Command c, Displayable d) {
        if (this.currentState == 0) {
            if (c == GlobalParameters.COMMAND_EXIT) {
                this.showConfirmation("Confirmation", "Really exit?");
            } else if (c == COMMAND_CLEAR) {
                this.editPanel.removeLastSymbol();
            } else if (c == COMMAND_EQUALS) {
                this.middleButton.pressMiddleButton(4);
            } else if (c == COMMAND_SCIENTIFIC_CALCULATOR) {
                DisplayManager.getInstance().pop();
                DisplayManager.getInstance().push((Displayable)this.midlet.getScientificCalculator());
                SettingsManager.getInstance().setDefaultCalculatorMode(1);
            } else if (c == COMMAND_LOAN_CALCULATOR) {
                if (SettingsManager.getInstance().isLoanCalculatorDisplayedFirstTime()) {
                    DisplayManager.getInstance().push((Displayable)new InstructionsForm(this.midlet, true, Local.getText(1)));
                } else {
                    DisplayManager.getInstance().pop();
                    DisplayManager.getInstance().push((Displayable)this.midlet.getLoanCalculator());
                }
            } else if (c == GlobalParameters.COMMAND_INSTRUCTIONS) {
                DisplayManager.getInstance().push((Displayable)new InstructionsForm(this.midlet, false, Local.getText(2)));
            }
        } else if (this.currentState == 2) {
            if (c == GlobalParameters.COMMAND_SELECT) {
                this.buttonPanel.commandAction(c, d);
            } else if (c == GlobalParameters.COMMAND_BACK) {
                this.changeState(3);
            }
        }
    }

    public int getCurrentState() {
        return this.currentState;
    }

    synchronized void changeState(int newState) {
        if (newState < 0 && newState > 3) {
            return;
        }
        this.currentState = newState;
        switch (this.currentState) {
            case 0: {
                this.addCommands();
                break;
            }
            case 1: {
                this.removeCommands();
                if (!(this.buttonPanel instanceof AdditionalFunctionsButtonPanel)) break;
                ((AdditionalFunctionsButtonPanel)this.buttonPanel).animate(true);
                break;
            }
            case 2: {
                this.addCommands();
                break;
            }
            case 3: {
                this.removeCommands();
                if (!(this.buttonPanel instanceof AdditionalFunctionsButtonPanel)) break;
                ((AdditionalFunctionsButtonPanel)this.buttonPanel).animate(false);
            }
        }
        this.repaint();
    }

    protected void keyRepeated(int keyCode) {
        super.keyRepeated(keyCode);
        if (this.currentState == 2) {
            this.keyPressed(keyCode);
        }
    }

    protected void keyPressed(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        if (this.currentState == 0) {
            if (keyCode >= 48 && keyCode <= 57 || keyCode >= 98 && keyCode != 117 && keyCode != 106 && keyCode != 228) {
                this.editPanel.keyPressed(keyCode, this.getGameAction(keyCode));
            } else if (gameAction == 1) {
                this.middleButton.pressMiddleButton(0);
            } else if (gameAction == 5) {
                this.middleButton.pressMiddleButton(3);
            } else if (gameAction == 6) {
                this.middleButton.pressMiddleButton(1);
            } else if (gameAction == 2) {
                this.middleButton.pressMiddleButton(2);
            } else if (keyCode == 42 || keyCode == 117) {
                this.changeState(1);
            } else if (keyCode == 35 || keyCode == 106 || keyCode == 228) {
                this.hashButton.press();
            } else if (gameAction == 8) {
                this.middleButton.pressMiddleButton(4);
            } else if (keyCode == -8 || keyCode == 8) {
                this.editPanel.removeLastSymbol();
            }
        } else if (this.currentState == 2) {
            if (keyCode == 42 || keyCode == 117) {
                this.changeState(3);
            } else if (keyCode == 35 || keyCode == 106 || keyCode == 228) {
                this.hashButton.press();
            } else if (gameAction == 8) {
                this.buttonPanel.commandAction(GlobalParameters.COMMAND_SELECT, (Displayable)this);
            } else {
                this.buttonPanel.keyPressed(keyCode, gameAction);
            }
        }
        this.repaint();
    }

    private void addCommands() {
        this.setCommandListener(this);
        if (this.currentState == 0) {
            this.addCommand(GlobalParameters.COMMAND_EXIT);
            if (this.isClearCommandPresent()) {
                this.addCommand(COMMAND_CLEAR);
            }
            this.addCommand(COMMAND_EQUALS);
            this.addCommand(COMMAND_SCIENTIFIC_CALCULATOR);
            this.addCommand(COMMAND_LOAN_CALCULATOR);
            this.addCommand(GlobalParameters.COMMAND_INSTRUCTIONS);
        } else if (this.currentState == 2) {
            this.addCommand(GlobalParameters.COMMAND_SELECT);
            this.addCommand(GlobalParameters.COMMAND_BACK);
        }
    }

    private void removeCommands() {
        this.removeCommand(GlobalParameters.COMMAND_EXIT);
        this.removeCommand(COMMAND_CLEAR);
        this.removeCommand(COMMAND_SCIENTIFIC_CALCULATOR);
        this.removeCommand(COMMAND_LOAN_CALCULATOR);
        this.removeCommand(GlobalParameters.COMMAND_INSTRUCTIONS);
        this.removeCommand(COMMAND_EQUALS);
        this.removeCommand(GlobalParameters.COMMAND_SELECT);
        this.removeCommand(GlobalParameters.COMMAND_BACK);
    }

    private void closeAlert() {
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
        this.alert = null;
    }

    protected void showConfirmation(String title, String text) {
        this.alert = new Alert(title, text, null, AlertType.CONFIRMATION);
        this.alert.addCommand(new Command("Yes", 4, 1));
        this.alert.addCommand(new Command("No", 3, 1));
        this.alert.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c.getLabel().equals("Yes")) {
                    StandardCanvas.this.closeAlert();
                    StandardCanvas.this.midlet.notifyDestroyed();
                }
                if (c.getLabel().equals("No")) {
                    StandardCanvas.this.closeAlert();
                }
            }
        });
        Display.getDisplay((MIDlet)this.midlet).setCurrent(this.alert, (Displayable)this);
    }
}

